<?php
session_start();
include 'conexao.php';

// Acesso restrito
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SECRETARIA PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

// Função para formatar a data para "dia de mês por extenso de ano"
function formatarDataExtenso($data) {
    if (empty($data) || $data === '0000-00-00') {
        return 'Não informado';
    }
    $dateObj = new DateTime($data);
    $meses = [
        1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril', 5 => 'Maio', 6 => 'Junho',
        7 => 'Julho', 8 => 'Agosto', 9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
    ];
    $dia = $dateObj->format('j');
    $mes = $meses[(int)$dateObj->format('n')];
    $ano = $dateObj->format('Y');
    return "{$dia} de {$mes} de {$ano}";
}

$alunos_db = $conn->query("SELECT id, nome FROM alunos ORDER BY nome")->fetch_all(MYSQLI_ASSOC);
$aluno_id = isset($_GET['aluno_id']) ? intval($_GET['aluno_id']) : 0;

$dados_aluno = null;
$notas_por_disciplina_e_classe = []; 
$media_final_geral = '-';
$curso_aluno = '';
$ano_conclusao = '';
$disciplinas_certificadas = [];

if ($aluno_id > 0) {
    // 1. Buscar dados detalhados do aluno
    $stmt_aluno = $conn->prepare("SELECT * FROM alunos WHERE id = ?");
    $stmt_aluno->bind_param("i", $aluno_id);
    $stmt_aluno->execute();
    $dados_aluno = $stmt_aluno->get_result()->fetch_assoc();
    $stmt_aluno->close();
    
    // Obter o curso da tabela matriculas
    // Esta consulta busca o curso e o último ano letivo registrado para o aluno
    $stmt_matriculas = $conn->prepare("
        SELECT curso, ano_letivo
        FROM matriculas
        WHERE aluno_id = ?
        ORDER BY ano_letivo DESC
        LIMIT 1
    ");
    $stmt_matriculas->bind_param("i", $aluno_id);
    $stmt_matriculas->execute();
    $res_matriculas = $stmt_matriculas->get_result()->fetch_assoc();
    $curso_aluno = $res_matriculas['curso'] ?? '';
    $ano_conclusao = $res_matriculas['ano_letivo'] ?? '';
    $stmt_matriculas->close();
    
    // 2. Buscar a lista de disciplinas do aluno dinamicamente
    $stmt_disciplinas = $conn->prepare("
        SELECT DISTINCT d.nome
        FROM disciplinas d
        JOIN notas n ON d.id = n.disciplina_id
        WHERE n.aluno_id = ?
    ");
    $stmt_disciplinas->bind_param("i", $aluno_id);
    $stmt_disciplinas->execute();
    $res_disciplinas = $stmt_disciplinas->get_result();
    while ($row_d = $res_disciplinas->fetch_assoc()) {
        $disciplinas_certificadas[] = $row_d['nome'];
    }
    $stmt_disciplinas->close();

    // Mapeamento de disciplinas para categorias
    $categorias_disciplinas = [
        'Língua Portuguesa' => 'Línguas',
        'Inglês I' => 'Línguas',
        'Inglês II' => 'Línguas',
        'Literatura' => 'Línguas',
        'Matemática' => 'Ciências Exatas',
        'Informática' => 'Ciências Exatas',
        'História' => 'Ciências Sociais/Humanas',
        'Geografia' => 'Ciências Sociais/Humanas',
        'Filosofia' => 'Ciências Sociais/Humanas',
        'Sociologia' => 'Ciências Sociais/Humanas',
        'Empreendedorismo' => 'Ciências Sociais/Humanas',
        'Educação Física' => 'Outras',
    ];
    
    // Define a ordem de prioridade das categorias
    $ordem_categorias = [
        'Línguas' => 1,
        'Ciências Exatas' => 2,
        'Ciências Sociais/Humanas' => 3,
        'Outras' => 4,
    ];

    // Função de comparação para ordenar as disciplinas (com prioridade para Língua Portuguesa)
    usort($disciplinas_certificadas, function($a, $b) use ($categorias_disciplinas, $ordem_categorias) {
        $cat_a = $categorias_disciplinas[$a] ?? 'Outras';
        $cat_b = $categorias_disciplinas[$b] ?? 'Outras';
        
        $ordem_a = $ordem_categorias[$cat_a];
        $ordem_b = $ordem_categorias[$cat_b];
        
        if ($ordem_a === $ordem_b) {
            if ($cat_a === 'Línguas') {
                if ($a === 'Língua Portuguesa') return -1;
                if ($b === 'Língua Portuguesa') return 1;
            }
            return strcmp($a, $b);
        }
        
        return $ordem_a - $ordem_b;
    });

    // 3. Buscar todas as notas finais (mf) do aluno E a classe correspondente
    $stmt_notas = $conn->prepare("
        SELECT d.nome AS disciplina, m.classe, n.mf
        FROM notas n
        JOIN disciplinas d ON n.disciplina_id = d.id
        JOIN matriculas m ON n.aluno_id = m.aluno_id AND n.turma_id = m.turma_id AND n.ano_lectivo = m.ano_letivo
        WHERE n.aluno_id = ?
    ");
    $stmt_notas->bind_param("i", $aluno_id);
    $stmt_notas->execute();
    $res_notas = $stmt_notas->get_result();

    $notas_para_media = [];

    while ($row = $res_notas->fetch_assoc()) {
        $disciplina = $row['disciplina'];
        $classe = $row['classe'];
        $nota = $row['mf'];

        if (in_array($disciplina, $disciplinas_certificadas)) {
            $notas_por_disciplina_e_classe[$disciplina][$classe] = $nota;
            $notas_para_media[] = $nota;
        }
    }
    $stmt_notas->close();

    // 4. Calcular a média final geral com base em todas as notas
    $total_notas = count($notas_para_media);
    if ($total_notas > 0) {
        $media_final_geral = round(array_sum($notas_para_media) / $total_notas);
    }
}

// Classes para exibir nas colunas (fixas)
$classes_para_exibir_db = ['10ª', '11ª', '12ª'];

// Determinar o género para ajustar o texto
$genero = strtolower($dados_aluno['genero'] ?? '');
$is_masculino = ($genero === 'masculino');
$texto_filho_filha = $is_masculino ? 'filho' : 'filha';
$texto_portador_portadora = $is_masculino ? 'portador' : 'portadora';
$texto_nascido_nascida = $is_masculino ? 'nascido' : 'nascida';
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Certificado de Conclusão</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        body {
            font-family: 'Times New Roman', serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #f0f0f0;
            font-size: 11.5px;
        }

        .container {
            width: 210mm;
            height: 297mm;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
            background-color: white;
            padding: 20mm;
            box-sizing: border-box;
            position: relative;
            background-image: url('certificado/modelo_certificado.jpg');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }

        .no-print {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #fff;
            padding: 10px;
            border-radius: 5px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.3);
            z-index: 1000;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1, .header h2, .header h3 {
            margin: 0;
            padding: 2px 0;
            font-weight: normal;
            font-size: 12px;
        }
        
        .header img {
            max-width: 80px;
            margin-bottom: 10px;
        }

        .certificado-titulo {
            font-size: 24px;
            font-weight: bold;
            text-align: center;
            margin-top: 30px;
            margin-bottom: 30px;
        }

        .texto-certificado {
            text-align: justify;
            text-indent: 40px;
            line-height: 1.5;
            margin-bottom: 20px;
            font-size: 11.5px;
        }
        
        .texto-certificado strong {
            font-weight: bold;
        }

        /* Estilo para o nome do aluno */
        .nome-aluno {
            color: red;
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            margin-bottom: 20px;
            font-size: 11px;
        }

        table, th, td {
            border: 1px solid #000;
        }

        th, td {
            padding: 3px;
            text-align: center;
        }
        
        .assinaturas {
            display: flex;
            justify-content: space-around;
            margin-top: 80px;
        }

        .assinaturas > div {
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            width: 250px;
        }

        .assinaturas p {
            margin: 0;
            padding: 0;
        }
        
        .assinatura-linha {
            width: 100%;
            border: 0;
            border-top: 1px solid #000;
            margin: 50px 0 5px 0;
        }

        @media print {
            body { background: none; }
            .no-print { display: none; }
            .container { 
                box-shadow: none; 
                border: none;
                background-image: url('certificado/modelo_certificado.jpg');
                background-size: cover;
                background-repeat: no-repeat;
                background-position: center;
            }
        }
    </style>
</head>
<body>

<div class="no-print">
    <form method="GET" action="">
        <label for="aluno_id">Selecionar Aluno:</label>
        <select name="aluno_id" id="aluno_id" onchange="this.form.submit()">
            <option value="0">- Selecione o Aluno -</option>
            <?php foreach ($alunos_db as $a): ?>
                <option value="<?= $a['id'] ?>" <?= ($a['id'] == $aluno_id) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($a['nome']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </form>
    <?php if ($aluno_id > 0 && $dados_aluno): ?>
        <button onclick="window.print()">Imprimir Certificado</button>
    <?php endif; ?>
</div>

<?php if ($aluno_id > 0 && $dados_aluno): ?>
<div class="container">
    <div class="header">
        <img src="insignia/insignia.png" alt="Insígnia">
        <h1>REPÚBLICA DE ANGOLA</h1>
        <h2>GOVERNO PROVINCIAL DE BENGUELA</h2>
        <h2>GABINETE PROVINCIAL DA EDUCAÇÃO</h2>
        <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</h3>
    </div>

    <h2 class="certificado-titulo">CERTIFICADO</h2>

    <div class="texto-certificado">
        Eduardo Sanjambela Tchandja, Director do Complexo Escolar BG0026 Padre Emil Frick - Catumbela, certifica que, <strong class="nome-aluno"><?= htmlspecialchars($dados_aluno['nome'] ?? '') ?></strong>, <?= $texto_filho_filha ?> de <strong><?= htmlspecialchars($dados_aluno['nome_pai'] ?? 'Desconhecido') ?></strong> e de <strong><?= htmlspecialchars($dados_aluno['nome_mae'] ?? 'Desconhecida') ?></strong>, <?= $texto_nascido_nascida ?> aos <strong><?= htmlspecialchars(formatarDataExtenso($dados_aluno['data_nascimento'] ?? '')) ?></strong>, no município de <strong><?= htmlspecialchars($dados_aluno['municipio'] ?? 'Não informado') ?></strong>, Província de <strong><?= htmlspecialchars($dados_aluno['provincia'] ?? 'Não informado') ?></strong>, <?= $texto_portador_portadora ?> do B.I nº<strong><?= htmlspecialchars($dados_aluno['bi_numero'] ?? 'Não informado') ?></strong>, passado pelo Arquivo de Identificação de <strong><?= htmlspecialchars($dados_aluno['bi_emitido_em'] ?? 'Não informado') ?></strong> aos <strong><?= htmlspecialchars(formatarDataExtenso($dados_aluno['bi_data_emissao'] ?? '')) ?></strong>.
    </div>

    <div class="texto-certificado" style="text-indent: 0;">
        Concluiu no ano lectivo <strong><?= htmlspecialchars($ano_conclusao) ?></strong>, o curso de <strong><?= htmlspecialchars($curso_aluno) ?></strong>, tendo obtido as seguintes classificações:
    </div>
    
    <table>
        <thead>
            <tr>
                <th>Disciplinas</th>
                <?php foreach ($classes_para_exibir_db as $classe_db): ?>
                    <th><?= htmlspecialchars($classe_db) ?> Classe</th>
                <?php endforeach; ?>
                <th>Média Final</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($disciplinas_certificadas as $disciplina_nome): ?>
                <tr>
                    <td style="text-align: left;"><?= htmlspecialchars($disciplina_nome) ?></td>
                    <?php 
                    $soma_notas_disciplina = 0;
                    $count_notas_disciplina = 0;
                    ?>
                    <?php foreach ($classes_para_exibir_db as $classe_db): ?>
                        <td>
                            <?php 
                            $nota = $notas_por_disciplina_e_classe[$disciplina_nome][$classe_db] ?? '-';
                            echo htmlspecialchars($nota);
                            if (is_numeric($nota)) {
                                $soma_notas_disciplina += $nota;
                                $count_notas_disciplina++;
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                    <td>
                        <?php
                        $media_disciplina = ($count_notas_disciplina > 0) ? round($soma_notas_disciplina / $count_notas_disciplina) : '-';
                        echo htmlspecialchars($media_disciplina);
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="texto-certificado">
        Obteve a classificação final de <strong><?= htmlspecialchars($media_final_geral) ?></strong> Valores.
    </div>
    <div class="texto-certificado">
        Por ser verdade e assim constar, se passou o presente Certificado que vai por mim assinado e autenticado com o carimbo a óleo em uso nesta Instituição.
    </div>
    <div style="text-align: center; margin-top: 10px; font-size: 11.5px;">
        Complexo Escolar BG0026 Padre Emil Frick – Catumbela, aos <strong><?= htmlspecialchars(formatarDataExtenso(date('Y-m-d'))) ?></strong>.
    </div>

    <div class="assinaturas">
        <div>
            <p>O Subdirector Pedagógico</p>
            <hr class="assinatura-linha">
            <p>Anacleto Domingos de Oliveira Cachiyenjo</p>
        </div>
        <div>
            <p>O Director</p>
            <hr class="assinatura-linha">
            <p>Eduardo Sanjambela Tchandja</p>
        </div>
    </div>
</div>
<?php elseif ($aluno_id > 0 && !$dados_aluno): ?>
    <p style="text-align: center;">Nenhum aluno encontrado com este ID. Por favor, tente novamente.</p>
<?php endif; ?>

</body>
</html>